package com.ruoyi.inventory.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.MaterialsCategoryMapper;
import com.ruoyi.inventory.domain.MaterialsCategory;
import com.ruoyi.inventory.service.IMaterialsCategoryService;

/**
 * 物料分类Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
@Service
public class MaterialsCategoryServiceImpl implements IMaterialsCategoryService 
{
    @Autowired
    private MaterialsCategoryMapper materialsCategoryMapper;

    /**
     * 查询物料分类
     * 
     * @param id 物料分类主键
     * @return 物料分类
     */
    @Override
    public MaterialsCategory selectMaterialsCategoryById(String id)
    {
        return materialsCategoryMapper.selectMaterialsCategoryById(id);
    }

    /**
     * 查询物料分类列表
     * 
     * @param materialsCategory 物料分类
     * @return 物料分类
     */
    @Override
    public List<MaterialsCategory> selectMaterialsCategoryList(MaterialsCategory materialsCategory)
    {
        return materialsCategoryMapper.selectMaterialsCategoryList(materialsCategory);
    }

    /**
     * 新增物料分类
     * 
     * @param materialsCategory 物料分类
     * @return 结果
     */
    @Override
    public int insertMaterialsCategory(MaterialsCategory materialsCategory)
    {
        materialsCategory.setCreateTime(DateUtils.getNowDate());
        return materialsCategoryMapper.insertMaterialsCategory(materialsCategory);
    }

    /**
     * 修改物料分类
     * 
     * @param materialsCategory 物料分类
     * @return 结果
     */
    @Override
    public int updateMaterialsCategory(MaterialsCategory materialsCategory)
    {
        materialsCategory.setUpdateTime(DateUtils.getNowDate());
        return materialsCategoryMapper.updateMaterialsCategory(materialsCategory);
    }

    /**
     * 批量删除物料分类
     * 
     * @param ids 需要删除的物料分类主键
     * @return 结果
     */
    @Override
    public int deleteMaterialsCategoryByIds(String[] ids)
    {
        return materialsCategoryMapper.deleteMaterialsCategoryByIds(ids);
    }

    /**
     * 删除物料分类信息
     * 
     * @param id 物料分类主键
     * @return 结果
     */
    @Override
    public int deleteMaterialsCategoryById(String id)
    {
        return materialsCategoryMapper.deleteMaterialsCategoryById(id);
    }
}
