package com.ruoyi.inventory.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 库存事务对象 inventory_transactions
 *
 * @author ruoyi
 * @date 2025-12-02
 */
public class InventoryTransactions extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 类型1-入库 2-出库 3-盘点调整 */
    @Excel(name = "类型1-入库 2-出库 3-盘点调整")
    private Long transactionType;

    // 库存表id
    private String inventoryId;
    /** 关联单号，相当于主记录 */
    @Excel(name = "关联单号，相当于主记录")
    private String referenceId;

    /** 子记录id */
    @Excel(name = "子记录id")
    private String referenceItemId;

    /** 货物ID */
    @Excel(name = "货物ID")
    private String materialId;

    /** 批次ID */
    @Excel(name = "批次ID")
    private String batchCode;

    /** 仓库ID */
    @Excel(name = "仓库ID")
    private String warehouseId;

    /** 库位ID */
    @Excel(name = "库位ID")
    private String locationId;

    /** 货主ID */
    @Excel(name = "货主ID")
    private String ownerId;

    /** 操作前数量 */
    @Excel(name = "操作前数量")
    private Long quantityBefore;

    /** 操作数量 */
    @Excel(name = "操作数量")
    private Long quantityChange;

    /** 操作后数量 */
    @Excel(name = "操作后数量")
    private Long quantityAfter;

    /** 操作时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "操作时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date transactionTime;

    /** 操作人ID */
    @Excel(name = "操作人ID")
    private String operatedBy;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    public String getInventoryId() {
        return inventoryId;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public String getId()
    {
        return id;
    }

    public void setTransactionType(Long transactionType)
    {
        this.transactionType = transactionType;
    }

    public Long getTransactionType()
    {
        return transactionType;
    }

    public void setReferenceId(String referenceId)
    {
        this.referenceId = referenceId;
    }

    public String getReferenceId()
    {
        return referenceId;
    }

    public void setReferenceItemId(String referenceItemId)
    {
        this.referenceItemId = referenceItemId;
    }

    public String getReferenceItemId()
    {
        return referenceItemId;
    }

    public void setMaterialId(String materialId)
    {
        this.materialId = materialId;
    }

    public String getMaterialId()
    {
        return materialId;
    }

    public void setBatchCode(String batchCode)
    {
        this.batchCode = batchCode;
    }

    public String getBatchCode()
    {
        return batchCode;
    }

    public void setWarehouseId(String warehouseId)
    {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId()
    {
        return warehouseId;
    }

    public void setLocationId(String locationId)
    {
        this.locationId = locationId;
    }

    public String getLocationId()
    {
        return locationId;
    }

    public void setOwnerId(String ownerId)
    {
        this.ownerId = ownerId;
    }

    public String getOwnerId()
    {
        return ownerId;
    }

    public void setQuantityBefore(Long quantityBefore)
    {
        this.quantityBefore = quantityBefore;
    }

    public Long getQuantityBefore()
    {
        return quantityBefore;
    }

    public void setQuantityChange(Long quantityChange)
    {
        this.quantityChange = quantityChange;
    }

    public Long getQuantityChange()
    {
        return quantityChange;
    }

    public void setQuantityAfter(Long quantityAfter)
    {
        this.quantityAfter = quantityAfter;
    }

    public Long getQuantityAfter()
    {
        return quantityAfter;
    }

    public void setTransactionTime(Date transactionTime)
    {
        this.transactionTime = transactionTime;
    }

    public Date getTransactionTime()
    {
        return transactionTime;
    }

    public void setOperatedBy(String operatedBy)
    {
        this.operatedBy = operatedBy;
    }

    public String getOperatedBy()
    {
        return operatedBy;
    }

    public void setIsUsed(Long isUsed)
    {
        this.isUsed = isUsed;
    }

    public Long getIsUsed()
    {
        return isUsed;
    }

    public void setSortNo(Long sortNo)
    {
        this.sortNo = sortNo;
    }

    public Long getSortNo()
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode)
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode()
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode)
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode()
    {
        return updateUserCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("transactionType", getTransactionType())
            .append("referenceId", getReferenceId())
            .append("referenceItemId", getReferenceItemId())
            .append("materialId", getMaterialId())
            .append("batchCode", getBatchCode())
            .append("warehouseId", getWarehouseId())
            .append("locationId", getLocationId())
            .append("ownerId", getOwnerId())
            .append("quantityBefore", getQuantityBefore())
            .append("quantityChange", getQuantityChange())
            .append("quantityAfter", getQuantityAfter())
            .append("transactionTime", getTransactionTime())
            .append("operatedBy", getOperatedBy())
            .append("remark", getRemark())
            .append("isUsed", getIsUsed())
            .append("sortNo", getSortNo())
            .append("createTime", getCreateTime())
            .append("createUserCode", getCreateUserCode())
            .append("updateTime", getUpdateTime())
            .append("updateUserCode", getUpdateUserCode())
            .toString();
    }
}
