package com.ruoyi.inventory.service;

import com.ruoyi.common.core.domain.entity.Materials;

import java.util.List;

/**
 * 物料Service接口
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
public interface IMaterialsService 
{
    /**
     * 查询物料
     * 
     * @param id 物料主键
     * @return 物料
     */
    public Materials selectMaterialsById(String id);

    /**
     * 查询物料列表
     * 
     * @param materials 物料
     * @return 物料集合
     */
    public List<Materials> selectMaterialsList(Materials materials);

    /**
     * 新增物料
     * 
     * @param materials 物料
     * @return 结果
     */
    public int insertMaterials(Materials materials);

    /**
     * 修改物料
     * 
     * @param materials 物料
     * @return 结果
     */
    public int updateMaterials(Materials materials);

    /**
     * 批量删除物料
     * 
     * @param ids 需要删除的物料主键集合
     * @return 结果
     */
    public int deleteMaterialsByIds(String[] ids);

    /**
     * 删除物料信息
     * 
     * @param id 物料主键
     * @return 结果
     */
    public int deleteMaterialsById(String id);

    public List<Materials> selectMaterialsByCategory(String id);


    public String importMaterials(List<Materials> materialsList, Boolean isUpdateSupport, String operName);
}
