package com.ruoyi.inventory.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.InboundOrderItemsMapper;
import com.ruoyi.inventory.domain.InboundOrderItems;
import com.ruoyi.inventory.service.IInboundOrderItemsService;

/**
 * 入库单明细Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
@Service
public class InboundOrderItemsServiceImpl implements IInboundOrderItemsService 
{
    @Autowired
    private InboundOrderItemsMapper inboundOrderItemsMapper;
    /**
     * 查询入库单明细
     * 
     * @param id 入库单明细主键
     * @return 入库单明细
     */
    @Override
    public InboundOrderItems selectInboundOrderItemsById(String id)
    {
        return inboundOrderItemsMapper.selectInboundOrderItemsById(id);
    }

    /**
     * 查询入库单明细列表
     * 
     * @param inboundOrderItems 入库单明细
     * @return 入库单明细
     */
    @Override
    public List<InboundOrderItems> selectInboundOrderItemsList(InboundOrderItems inboundOrderItems)
    {
        return inboundOrderItemsMapper.selectInboundOrderItemsList(inboundOrderItems);
    }

    /**
     * 新增入库单明细
     * 
     * @param inboundOrderItems 入库单明细
     * @return 结果
     */
    @Override
    public int insertInboundOrderItems(InboundOrderItems inboundOrderItems)
    {
        inboundOrderItems.setCreateTime(DateUtils.getNowDate());

        return inboundOrderItemsMapper.insertInboundOrderItems(inboundOrderItems);
    }

    /**
     * 修改入库单明细
     * 
     * @param inboundOrderItems 入库单明细
     * @return 结果
     */
    @Override
    public int updateInboundOrderItems(InboundOrderItems inboundOrderItems)
    {
        inboundOrderItems.setUpdateTime(DateUtils.getNowDate());
        return inboundOrderItemsMapper.updateInboundOrderItems(inboundOrderItems);
    }

    /**
     * 批量删除入库单明细
     * 
     * @param ids 需要删除的入库单明细主键
     * @return 结果
     */
    @Override
    public int deleteInboundOrderItemsByIds(String[] ids)
    {
        return inboundOrderItemsMapper.deleteInboundOrderItemsByIds(ids);
    }

    /**
     * 删除入库单明细信息
     * 
     * @param id 入库单明细主键
     * @return 结果
     */
    @Override
    public int deleteInboundOrderItemsById(String id)
    {
        return inboundOrderItemsMapper.deleteInboundOrderItemsById(id);
    }
}
