package com.ruoyi.inventory.domain.TO;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.poi.ss.usermodel.IndexedColors;

/**
 * 入库单明细对象 inbound_order_items
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@Data
public class InboundItemsTO extends BaseEntity {
    private static final long serialVersionUID = 1L;

    // ======================== 匹配Excel表头的字段（按表头顺序） ========================
    /** 日期 */
    @Excel(name = "日期",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String inboundDate; // 建议用LocalDateTime，若Excel是字符串格式则用String

    /** SAP No */
    @Excel(name = "SAP No",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String sapNo;

    /** 物料名称 */
    @Excel(name = "物料名称",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String materialName;

    /** TS Code */
    @Excel(name = "TS Code",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String tsCode;

    /** 批号 */
    @Excel(name = "批号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String batchId;

    /** 计划数量 */
    @Excel(name = "计划数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long plannedQuantity;

    /** 件重 */
    @Excel(name = "件重",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double unitWeight;

    /** 约数 */
    @Excel(name = "约数",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long divisor;

    /** 件数 */
    @Excel(name = "件数",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long actualPackages;

    /** 实发数量 */
    @Excel(name = "实发数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long actualQuantity;

    /** 重量 */
    @Excel(name = "重量(成品)",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double weight;

    /** 库位 */
    @Excel(name = "库位",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String locationName;

    /** 仓库 */
    @Excel(name = "仓库",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String warehouseId;

    /** 库位(成品) */
    @Excel(name = "目标库位(成品)",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String finishedLocation;

    /** 备注(TRDC) */
    @Excel(name = "备注(TRDC)",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String remarkTrdc;

    /** 收货库位(正常) */
    @Excel(name = "收货库位(正常)",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String relocation;

    /** 标签颜色 */
    @Excel(name = "标签颜色",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String labelColorName;

    /** 凭证号 */
    @Excel(name = "凭证号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String voucherNumber;

    /** 保温 */
    @Excel(name = "保温",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String keepWarm;

    /** 危险类别 */
    @Excel(name = "危险类别",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String hazardId;

    /** 单号 */
    @Excel(name = "单号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String orderId;

    /** 系统编号 */
    @Excel(name = "系统编号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String systemNo;

    /** 智观（客户订单号） */
    @Excel(name = "智观（客户订单号）",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String finishedOrderId;

    /** 客户订单号/PO号 */
    @Excel(name = "客户订单号/PO号",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String finishedSystemNo;

    /** 货主 */
    @Excel(name = "货主",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private String ownerId;

    /** 贴标数量 */
    @Excel(name = "贴标数量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long labelQuantity;

    /** 订单类型 */
    @Excel(name = "订单类型",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Long orderType;

    /** 单件重量 */
    @Excel(name = "单件重量",headerColor = IndexedColors.BLACK,headerBackgroundColor = IndexedColors.WHITE)
    private Double packageWeight;

    // ======================== 原有类中多的字段（放在末尾） ========================
    /** 编号 */
    private String id;

    /** 入库单号 检索条件（主表Id） */

    private String inboundOrderId;

    /** 货物ID 字典，检索条件 */
    private String materialId;

    /** 仓库名称 */
    private String warehousesName;

    /** 库位ID */
    private String locationId;

    private Long labelColor;
    /** 计划件数 暂无用 */

    private Long plannedPackages;

    /** 实际数量（原有） */

    private Long actualQuantity1;

    /** 实际件数 */

    private Long actualPackages1;

    /** 单价 */

    private Long unitPrice;

    /** 状态1-待收货 2-部分收货 3-已完成 暂无用 */
    private Long itemStatus;

    /** 收货时间 暂无用 */

    private Long receivedAt;

    /** 收货人 */

    private String receivedBy;

    /** 应用数据1使用0删除 删除用 */
    private Long isUsed;

    /** 排序 */
    private Long sortNo;

    /** 创建人编码 */
    private String createUserCode;

    /** 更新人编码 */
    private String updateUserCode;

    private Integer orderStatus;

    private String orderTypeId;
}