import request from '@/utils/request'

// 查询盘点单主列表
export function listStocktakes(query) {
  return request({
    url: '/inventory/stocktakes/list',
    method: 'get',
    params: query
  })
}

// 查询盘点单主详细
export function getStocktakes(id) {
  return request({
    url: '/inventory/stocktakes/' + id,
    method: 'get'
  })
}

// 新增盘点单主
export function addStocktakes(data) {
  return request({
    url: '/inventory/stocktakes',
    method: 'post',
    data: data
  })
}

// 修改盘点单主
export function updateStocktakes(data) {
  return request({
    url: '/inventory/stocktakes',
    method: 'put',
    data: data
  })
}

// 删除盘点单主
export function delStocktakes(id) {
  return request({
    url: '/inventory/stocktakes/' + id,
    method: 'delete'
  })
}
