package com.ruoyi.inventory.service;

import java.util.List;
import com.ruoyi.inventory.domain.Stocktakes;
import com.ruoyi.inventory.domain.TO.StocktakesTO;

/**
 * 库存盘点Service接口
 *
 * @author ruoyi
 * @date 2025-12-02
 */
public interface IStocktakesService
{
    /**
     * 查询库存盘点
     *
     * @param id 库存盘点主键
     * @return 库存盘点
     */
    public Stocktakes selectStocktakesById(String id);

    /**
     * 查询库存盘点列表
     *
     * @param stocktakes 库存盘点
     * @return 库存盘点集合
     */
    public List<Stocktakes> selectStocktakesList(Stocktakes stocktakes);

    /**
     * 新增库存盘点
     *
     * @param stocktakes 库存盘点
     * @return 结果
     */
    public int insertStocktakes(Stocktakes stocktakes);

    /**
     * 修改库存盘点
     *
     * @param stocktakes 库存盘点
     * @return 结果
     */
    public int updateStocktakes(StocktakesTO stocktakes);

    /**
     * 批量删除库存盘点
     *
     * @param ids 需要删除的库存盘点主键集合
     * @return 结果
     */
    public int deleteStocktakesByIds(String[] ids);

    /**
     * 删除库存盘点信息
     *
     * @param id 库存盘点主键
     * @return 结果
     */
    public int deleteStocktakesById(String id);
}
