package com.ruoyi.inventory.service;

import java.util.List;

import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.inventory.domain.ReturnOrderItems;
import com.ruoyi.inventory.domain.ReturnOrders;
import com.ruoyi.inventory.domain.vo.ReturnOrdersSummaryVO;

/**
 * 退库单明细Service接口
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
public interface IReturnOrderItemsService 
{
    /**
     * 查询退库单明细
     * 
     * @param id 退库单明细主键
     * @return 退库单明细
     */
    public ReturnOrderItems selectReturnOrderItemsById(String id);

    /**
     * 查询退库单明细列表
     * 
     * @param returnOrderItems 退库单明细
     * @return 退库单明细集合
     */
    public List<ReturnOrderItems> selectReturnOrderItemsList(ReturnOrderItems returnOrderItems);

    /**
     * 新增退库单明细
     * 
     * @param returnOrderItems 退库单明细
     * @return 结果
     */
    public int insertReturnOrderItems(ReturnOrderItems returnOrderItems);

    /**
     * 修改退库单明细
     * 
     * @param returnOrderItems 退库单明细
     * @return 结果
     */
    public int updateReturnOrderItems(ReturnOrderItems returnOrderItems);

    /**
     * 批量删除退库单明细
     * 
     * @param ids 需要删除的退库单明细主键集合
     * @return 结果
     */
    public int deleteReturnOrderItemsByIds(String[] ids);

    /**
     * 删除退库单明细信息
     * 
     * @param id 退库单明细主键
     * @return 结果
     */
    public int deleteReturnOrderItemsById(String id);

    /**
     * 查询退库单统计结果
     *
     * @param returnOrderItems 查询条件
     * @return 退库单统计信息
     */
    public List<ReturnOrdersSummaryVO> selectReturnOrderCount(ReturnOrderItems returnOrderItems);
}

