package com.ruoyi.inventory.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.inventory.mapper.StorageLocationsCategoryMapper;
import com.ruoyi.inventory.domain.StorageLocationsCategory;
import com.ruoyi.inventory.service.IStorageLocationsCategoryService;

/**
 * 库位存放分类Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-01
 */
@Service
public class StorageLocationsCategoryServiceImpl implements IStorageLocationsCategoryService 
{
    @Autowired
    private StorageLocationsCategoryMapper storageLocationsCategoryMapper;

    /**
     * 查询库位存放分类
     * 
     * @param id 库位存放分类主键
     * @return 库位存放分类
     */
    @Override
    public StorageLocationsCategory selectStorageLocationsCategoryById(String id)
    {
        return storageLocationsCategoryMapper.selectStorageLocationsCategoryById(id);
    }

    /**
     * 查询库位存放分类列表
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 库位存放分类
     */
    @Override
    public List<StorageLocationsCategory> selectStorageLocationsCategoryList(StorageLocationsCategory storageLocationsCategory)
    {
        return storageLocationsCategoryMapper.selectStorageLocationsCategoryList(storageLocationsCategory);
    }

    /**
     * 新增库位存放分类
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 结果
     */
    @Override
    public int insertStorageLocationsCategory(StorageLocationsCategory storageLocationsCategory)
    {
        storageLocationsCategory.setCreateTime(DateUtils.getNowDate());
        return storageLocationsCategoryMapper.insertStorageLocationsCategory(storageLocationsCategory);
    }

    /**
     * 修改库位存放分类
     * 
     * @param storageLocationsCategory 库位存放分类
     * @return 结果
     */
    @Override
    public int updateStorageLocationsCategory(StorageLocationsCategory storageLocationsCategory)
    {
        storageLocationsCategory.setUpdateTime(DateUtils.getNowDate());
        return storageLocationsCategoryMapper.updateStorageLocationsCategory(storageLocationsCategory);
    }

    /**
     * 批量删除库位存放分类
     * 
     * @param ids 需要删除的库位存放分类主键
     * @return 结果
     */
    @Override
    public int deleteStorageLocationsCategoryByIds(String[] ids)
    {
        return storageLocationsCategoryMapper.deleteStorageLocationsCategoryByIds(ids);
    }

    /**
     * 删除库位存放分类信息
     * 
     * @param id 库位存放分类主键
     * @return 结果
     */
    @Override
    public int deleteStorageLocationsCategoryById(String id)
    {
        return storageLocationsCategoryMapper.deleteStorageLocationsCategoryById(id);
    }
}
