module.exports = {
  'env': {
    'browser': true,
    'es2021': true,
    'node': true,
    'vue/setup-compiler-macros': true
  },
  'extends': [
    'eslint:recommended',
    'plugin:vue/vue3-essential'
    // './.eslintrc-auto-import.json'
  ],
  globals: {
    'ImportOption': true,
    'TreeType': true,
    'FieldOption': true,
    'PageData': true,
    'storeToRefs': true,
    'DictDataOption': true,
    'UploadOption': true,
    'TMap': true
  },
  'overrides': [
  ],
  'parserOptions': {
    'ecmaVersion': 'latest',
    parser: '@typescript-eslint/parser',
    'sourceType': 'module'
  },
  'plugins': [
    'vue',
    '@typescript-eslint'
  ],
  'rules': {
    '@typescript-eslint/ban-ts-comment': ['error', { 'ts-ignore': 'allow-with-description' }],
    '@typescript-eslint/explicit-function-return-type': 'off',
    '@typescript-eslint/explicit-module-boundary-types': 'off',
    '@typescript-eslint/no-empty-function': ['error', { allow: ['arrowFunctions'] }],
    '@typescript-eslint/no-explicit-any': 'off',
    '@typescript-eslint/no-non-null-assertion': 'off',
    '@typescript-eslint/no-var-requires': 'off',
    '@typescript-eslint/no-unused-vars': 'off',
    '@typescript-eslint/no-use-before-define': 'off',
    // '@typescript-eslint/ban-types': 'off',
    '@typescript-eslint/ban-types': [
      'error',
      {
        // 关闭空类型检查 {}
        extendDefaults: true,
        types: {
          '{}': false,
          Function: false
        }
      }
    ],


    'prettier/prettier': 'off',
    // 'indent': ['error', 2],
    'indent': [2, 2, {
      'SwitchCase': 1, // switch case 缩进
      'VariableDeclarator': 'first' // 变量声明
    }], // 缩进风格
    'no-mixed-spaces-and-tabs': 'error', // 不能空格与tab混用
    'linebreak-style': [
      0,
      'unix'
    ],
    'quotes': [2, 'single'], // 引号类型 `` "" ''
    'semi': [2, 'never'], // 关闭语句强制分号结尾
    // 箭头函数
    'arrow-spacing': [2, {
      before: true,
      after: true
    }],

    'no-alert': 2, // 禁止使用alert confirm prompt
    'no-caller': 2, // 禁止使用arguments.caller或arguments.callee
    'no-cond-assign': 2, // 禁止在条件表达式中使用赋值语句
    'no-const-assign': 2, // 禁止修改const声明的变量
    'no-constant-condition': 2, // 禁止在条件中使用常量表达式 if(true) if(1)
    'no-dupe-keys': 2, // 在创建对象字面量时不允许键重复 {a:1,a:1}
    'no-dupe-args': 2, // 函数参数不能重复
    'no-duplicate-case': 2, // switch中的case标签不能重复
    'no-else-return': 2, // 如果if语句里面有return,后面不能跟else语句
    'no-invalid-regexp': 2, // 禁止无效的正则表达式
    'no-invalid-this': 2, // 禁止无效的this，只能用在构造器，类，对象字面量
    'no-irregular-whitespace': 2, // 不使用非法空白
    'no-multi-spaces': 2, // 不能用多余的空格
    'no-case-declarations': 0,
    'block-spacing': ['error', 'always'], // 单行语句块的内侧要有空格
    'brace-style': ['error', '1tbs', { 'allowSingleLine': true }], // 1tbs
    'object-curly-spacing': [2, 'always'], // 是否允许非空对象里面有多余的空格
    'array-bracket-spacing': [2, 'never'], // 是否允许非空数组里面有多余的空格
    'new-cap': 0, // class命名第一字母大写
    'no-multiple-empty-lines': [2, {
      'max': 2
    }], // 空行最多不能超过2行
    'no-sequences': 2, // 禁止使用逗号运算符
    // 'no-spaced-func': 2, // 函数调用时 函数名与()之间不能有空格
    'func-call-spacing': ['error', 'never'], // 函数调用时 函数名与()之间不能有空格
    'no-trailing-spaces': 2, // 一行结束后面不要有空格
    'no-var': 2, // 禁用var，用let和const代替
    'camelcase': 1, // 强制驼峰法命名
    'consistent-this': [1, 'this'], // this别名
    // "default-case": 2, // switch语句最后必须有default
    'eol-last': 0, // 文件以单一的换行符结束
    'eqeqeq': 2, // 必须使用全等
    'generator-star-spacing': 2, // 生成器函数*的前后空格
    'init-declarations': 0, // 声明时必须赋初值
    'comma-dangle': [2, 'never'], // 对象字面量项尾不能有逗号
    'no-unneeded-ternary': 2, // 禁止不必要的嵌套 var isYes = answer === 1 ? true : false;
    'quote-props': [0, 'always'], // 对象字面量中的属性名是否强制双引号
    // 'no-unused-vars': 'off',
    'one-var': 0, // 连续声明
    'no-unused-vars': [0, {
      // 允许声明未使用变量
      'vars': 'local',
      // 参数不检查
      'args': 'none'
    }],
    'comma-spacing': [2, {
      'before': false,
      'after': true
    }], // 逗号后面有一个空格
    // "comma-dangle": [2, { // 无多余逗号
    //   "arrays": "never",
    //   "objects": "never",
    //   "imports": "never",
    //   "exports": "never",
    //   "functions": "ignore"
    // }],
    'space-before-blocks': ['error', 'always'],
    'space-in-parens': 2, // 函数参数列表括号内侧无空格
    'space-infix-ops': 2, // 中缀操作符（infix operators）前后要有一个空格
    'spaced-comment': [2, 'always', { // 注释符号后面要有空白
      'markers': ['global', 'globals', 'eslint', 'eslint-disable', '*package', '!', ',']
    }],
    'space-unary-ops': [2, {
      'words': true,
      'nonwords': false
    }], // 一元运算符的前/后要不要加空格
    'template-curly-spacing': 2, // 模板字符串大括号内侧无空格
    'space-before-function-paren': ['error', {
      'anonymous': 'always',
      'named': 'never',
      'asyncArrow': 'always'
    }], // 函数定义时括号前面要不要有空格 "anonymous": "always", "named": "never", "asyncArrow": "always"
    // key值前面是否要有空格
    'key-spacing': [2, {
      'singleLine': {
        'beforeColon': false,
        'afterColon': true
      },
      'multiLine': {
        'beforeColon': false,
        'afterColon': true
        // "align": "colon"
      }
    }],
    'keyword-spacing': ['error', {
      'before': true,
      'after': true
    }],
    'handle-callback-err': 0, // 失败回调参数err
    'prefer-promise-reject-errors': 0, // reject
    'no-useless-return': 0,
    'no-mixed-operators': 0, // && 和 || 混合使用
    'no-new-func': 0, // 不允许字符串函数
    'no-unreachable': 0, // 防止使用swtich语句 语法检查报错

    'vue/require-default-prop': 'off',
    'vue/multi-word-component-names': 'off',
    'vue/no-unused-vars': 'off',
    'vue/max-attributes-per-line': ['error', {
      'singleline': {
        'max': 3
      },
      'multiline': {
        'max': 1
      }
    }],
    'vue/first-attribute-linebreak': ['error', {
      'singleline': 'beside',
      'multiline': 'below'
    }],
    'vue/html-indent': ['error', 2, {
      'attribute': 1,
      'baseIndent': 1,
      'closeBracket': 0,
      'alignAttributesVertically': true,
      'ignores': []
    }],
    'vue/html-self-closing': ['error', {
      'html': {
        'void': 'never',
        'normal': 'always',
        'component': 'always'
      },
      'svg': 'always',
      'math': 'always'
    }],
    'vue/no-multi-spaces': ['error', {
      'ignoreProperties': false
    }],
    'vue/no-spaces-around-equal-signs-in-attribute': ['error']
  }
}
