import request from '@/utils/request'

// 查询考勤记录明细列表
export function listAttRecordItem(query) {
  return request({
    url: '/attendance/attRecordItem/list',
    method: 'get',
    params: query
  })
}

// 查询考勤记录明细详细
export function getAttRecordItem(id) {
  return request({
    url: '/attendance/attRecordItem/' + id,
    method: 'get'
  })
}

// 新增考勤记录明细
export function addAttRecordItem(data) {
  return request({
    url: '/attendance/attRecordItem',
    method: 'post',
    data: data
  })
}

// 修改考勤记录明细
export function updateAttRecordItem(data) {
  return request({
    url: '/attendance/attRecordItem/edit',
    method: 'post',
    data: data
  })
}

// 删除考勤记录明细
export function delAttRecordItem(id) {
  return request({
    url: '/attendance/attRecordItem/delete',
    method: 'post',
    data: id
  })
}


// 列表点击-查询考勤明细
export function getTAttRecordItemDTO(data) {
  return request({
    url: '/attendance/attRecordItem/getTAttRecordItemDTO',
    method: 'post',
    data: data
  })
}

// 新增考勤记录修改
export function addCheckRecordUpdate(data) {
  return request({
    url: '/attendance/checkRecordUpdate',
    method: 'post',
    data: data
  })
}


// 修改考勤状态
export function addCheckRecordUpdateInfo(data) {
  return request({
    url: '/attendance/attRecordItem/addCheckRecordUpdateInfo',
    method: 'post',
    data: data
  })
}
