import request from '@/utils/request'

// 查询考勤地点列表
export function listPLACE(query) {
  return request({
    url: '/attendance/attendancePlace/list',
    method: 'get',
    params: query
  })
}

// 查询考勤地点详细
export function getPLACE(id) {
  return request({
    url: '/attendance/attendancePlace/' + id,
    method: 'get'
  })
}

// 新增考勤地点
export function addPLACE(data) {
  return request({
    url: '/attendance/attendancePlace',
    method: 'post',
    data: data
  })
}

// 修改考勤地点
export function updatePLACE(data) {
  return request({
    url: '/attendance/attendancePlace/edit',
    method: 'post',
    data: data
  })
}

// 删除考勤地点
export function delPLACE(id) {
  return request({
    url: '/attendance/attendancePlace/delete/' + id,
    method: 'post'
  })
}

// 查询考勤点人员列表
export function listPlaceUser(query) {
  return request({
    url: '/attendance/placeUser/list',
    method: 'get',
    params: query
  })
}

// 提交考勤点人员列表
export function insertTAttPlaceUserByUserList(query) {
  return request({
    url: '/attendance/placeUser/insertTAttPlaceUserByUserList',
    method: 'post',
    params: { ...query }
  })
}

// 获取在职人员
export function getUserList(query) {
  return request({
    url: '/attendance/attendancePlace/getUserList',
    method: 'get',
    params: query
  })
}