import request from '@/utils/request'

// 查询考勤记录列表
export function listEmployeeAttendance(query) {
  return request({
    url: '/attendance/employeeAttendance/list',
    method: 'get',
    params: query
  })
}

// 查询考勤记录详细
export function getEmployeeAttendance(id) {
  return request({
    url: '/attendance/employeeAttendance/' + id,
    method: 'get'
  })
}

// 新增考勤记录
export function addEmployeeAttendance(data) {
  return request({
    url: '/attendance/employeeAttendance',
    method: 'post',
    data: data
  })
}

// 修改考勤记录
export function updateEmployeeAttendance(data) {
  return request({
    url: '/attendance/employeeAttendance/edit',
    method: 'post',
    data: data
  })
}

// 删除考勤记录
export function delEmployeeAttendance(id) {
  return request({
    url: '/attendance/employeeAttendance/delete',
    method: 'post',
    data: id
  })
}

// 生成考勤月记录
export function generateMonthRecord() {
  return request({
    url: '/attendance/employeeAttendance/generateMonthRecord',
    method: 'post'
  })
}

// 生成考勤日记录
export function generateDayRecord(param) {
  return request({
    url: '/attendance/employeeAttendance/generateDayRecord',
    method: 'post',
    param: { ...param }
  })
}
// 获取考勤记录
export function getCheckRecord(query) {
  return request({
    url: '/attendance/checkRecordPull/getCheckRecord',
    method: 'get',
    param: query
  })
}

