import request from '@/utils/request'

// 查询假期列表
export function listHoliday(query) {
  return request({
    url: '/attendance/holiday/list',
    method: 'get',
    params: query
  })
}

// 查询假期详细
export function getHoliday(id) {
  return request({
    url: '/attendance/holiday/' + id,
    method: 'get'
  })
}

// 新增假期
export function addHoliday(data) {
  return request({
    url: '/attendance/holiday',
    method: 'post',
    data: data
  })
}

// 修改假期
export function updateHoliday(data) {
  return request({
    url: '/attendance/holiday/edit',
    method: 'post',
    data: data
  })
}

// 删除假期
export function delHoliday(id) {
  return request({
    url: '/attendance/holiday/delete/' + id,
    method: 'post'
  })
}
