import request from '@/utils/request'

// 查询请假申请列表
export function listLeaveRequest(query) {
  return request({
    url: '/attendance/leaveRequest/list',
    method: 'get',
    params: query
  })
}

// 查询请假申请详细
export function getLeaveRequest(id) {
  return request({
    url: '/attendance/leaveRequest/' + id,
    method: 'get'
  })
}

// 新增请假申请
export function addLeaveRequest(data) {
  return request({
    url: '/attendance/leaveRequest',
    method: 'post',
    data: data
  })
}

// 修改请假申请
export function updateLeaveRequest(data) {
  return request({
    url: '/attendance/leaveRequest/edit',
    method: 'post',
    data: data
  })
}

// 删除请假申请
export function delLeaveRequest(id) {
  return request({
    url: '/attendance/leaveRequest/delete/' + id,
    method: 'post'
  })
}


// 新增销假申请
export function addLeaveRequrstBack(data) {
  return request({
    url: '/attendance/leaveRequrstBack',
    method: 'post',
    data: data
  })
}

// 查询销假申请详情
export function getInfoByLeaveRequestId(id) {
  return request({
    url: '/attendance/leaveRequrstBack/getInfoByLeaveRequestId/' + id,
    method: 'get'
  })
}

// 修改销假申请
export function updateLeaveRequrstBack(data) {
  return request({
    url: '/attendance/leaveRequrstBack/edit',
    method: 'post',
    data: data
  })
}

export function getRestTime() {
  return request({
    url: '/attendance/leaveRequest/getRestTime',
    method: 'get'
  })
}
// 根据销假id查询销假申请详情
export function getLeaveRequrstBack(id) {
  return request({
    url: '/attendance/leaveRequrstBack/' + id,
    method: 'get'
  })
}
export function getFlowParam() {
  return request({
    url: '/attendance/attFlowParamGenarate/getParam',
    method: 'get'
  })
}

// 人事修改请假申请
export function updateTAttLeaveRequestByPersonnel(data) {
  return request({
    url: '/attendance/leaveRequest/updateTAttLeaveRequestByPersonnel',
    method: 'post',
    data: data
  })
}