import request from '@/utils/request'

// 查询考勤机管理列表
export function listMachine(query) {
  return request({
    url: '/attendance/machine/list',
    method: 'get',
    params: query
  })
}

// 查询考勤机管理详细
export function getMachine(id) {
  return request({
    url: '/attendance/machine/' + id,
    method: 'get'
  })
}

// 新增考勤机管理
export function addMachine(data) {
  return request({
    url: '/attendance/machine',
    method: 'post',
    data: data
  })
}

// 修改考勤机管理
export function updateMachine(data) {
  return request({
    url: '/attendance/machine/edit',
    method: 'post',
    data: data
  })
}

// 删除考勤机管理
export function delMachine(id) {
  return request({
    url: '/attendance/machine/delete/' + id,
    method: 'post'
  })
}
// 测试对应IP和端口是否可连接
export function checkConnect(data) {
  return request({
    url: '/attendance/machine/checkConnect',
    method: 'get',
    params: data
  })
}
