import request from '@/utils/request'

// 查询加班调休列表
export function listOverTimeForLeave(query) {
  return request({
    url: '/attendance/overTimeForLeave/list',
    method: 'get',
    params: query
  })
}

// 查询加班调休详细
export function getOverTimeForLeave(id) {
  return request({
    url: '/attendance/overTimeForLeave/' + id,
    method: 'get'
  })
}

// 新增加班调休
export function addOverTimeForLeave(data) {
  return request({
    url: '/attendance/overTimeForLeave',
    method: 'post',
    data: data
  })
}

// 修改加班调休
export function updateOverTimeForLeave(data) {
  return request({
    url: '/attendance/overTimeForLeave/edit',
    method: 'post',
    data: data
  })
}

// 删除加班调休
export function delOverTimeForLeave(id) {
  return request({
    url: '/attendance/overTimeForLeave/delete/' + id,
    method: 'post'
  })
}
// 管理员修改加班调休
export function updateByAdmin(data) {
  return request({
    url: '/attendance/overTimeForLeave/updateByAdmin',
    method: 'post',
    data: data
  })
}