import request from '@/utils/request'

// 查询加班申请列表
export function listOvertimeWork(query) {
  return request({
    url: '/attendance/overtimeWork/list',
    method: 'get',
    params: query
  })
}

// 查询加班申请详细
export function getOvertimeWork(id) {
  return request({
    url: '/attendance/overtimeWork/' + id,
    method: 'get'
  })
}

// 新增加班申请
export function addOvertimeWork(data) {
  return request({
    url: '/attendance/overtimeWork',
    method: 'post',
    data: data
  })
}

// 修改加班申请
export function updateOvertimeWork(data) {
  return request({
    url: '/attendance/overtimeWork/edit',
    method: 'post',
    data: data
  })
}

// 删除加班申请
export function delOvertimeWork(id) {
  return request({
    url: '/attendance/overtimeWork/delete/' + id,
    method: 'post'
  })
}


// 管理员修改调休申请
export function updateByAdmin(data) {
  return request({
    url: '/attendance/overtimeWork/updateByAdmin',
    method: 'post',
    data: data
  })
}
