import request from '@/utils/request'

// 查询签卡列表
export function listRegistrationCard(query) {
  return request({
    url: '/attendance/registrationCard/list',
    method: 'get',
    params: query
  })
}

// 查询签卡详细
export function getRegistrationCard(id) {
  return request({
    url: '/attendance/registrationCard/' + id,
    method: 'get'
  })
}

// 新增签卡
export function addRegistrationCard(data) {
  return request({
    url: '/attendance/registrationCard',
    method: 'post',
    data: data
  })
}

// 修改签卡
export function updateRegistrationCard(data) {
  return request({
    url: '/attendance/registrationCard/edit',
    method: 'post',
    data: data
  })
}

// 删除签卡
export function delRegistrationCard(id) {
  return request({
    url: '/attendance/registrationCard/delete',
    method: 'post',
    data: id
  })
}

// 签卡详情
export function getTAttRecordItemByDay(id) {
  return request({
    url: '/attendance/attMobile/getTAttRecordItemByDay',
    method: 'post',
    data: id
  })
}
