import request from '@/utils/request'

// 查询考勤班次列表
export function listSHIFTS(query) {
  return request({
    url: '/attendance/attendanceShifts/list',
    method: 'get',
    params: query
  })
}

// 查询考勤班次详细
export function getSHIFTS(id) {
  return request({
    url: '/attendance/attendanceShifts/' + id,
    method: 'get'
  })
}

// 新增考勤班次
export function addSHIFTS(data) {
  return request({
    url: '/attendance/attendanceShifts',
    method: 'post',
    data: data
  })
}

// 修改考勤班次
export function updateSHIFTS(data) {
  return request({
    url: '/attendance/attendanceShifts/edit',
    method: 'post',
    data: data
  })
}

// 删除考勤班次
export function delSHIFTS(id) {
  return request({
    url: '/attendance/attendanceShifts/delete/' + id,
    method: 'post'
  })
}


// 查询考勤班次列表-不分页
export function getShiftsList(query) {
  return request({
    url: '/attendance/attendanceShifts/getList',
    method: 'get',
    params: query
  })
}