import request from '@/utils/request'

// 查询每日统计列表
export function getDayStatics(query) {
  return request({
    url: '/attendance/attStatics/getDayStatics',
    method: 'get',
    params: query
  })
}

// 查询每日异常列表
export function getDayAbnormalStatics(query) {
  return request({
    url: '/attendance/attStatics/getDayAbnormalStatics',
    method: 'get',
    params: query
  })
}

// 查询每日异常列表
export function getMonthStatics(data) {
  return request({
    url: '/attendance/attStatics/getMonthStatics',
    method: 'post',
    data: data
  })
}

// 生成月记录
export function generateMonthData(query) {
  return request({
    url: '/attendance/attStatics/generateMonthData',
    method: 'get',
    params: query
  })
}

// 查询每日异常列表
export function getMonthOverWorkStatics(query) {
  return request({
    url: '/attendance/attStatics/getMonthOverWorkStatics',
    method: 'get',
    params: query
  })
}
// 查询月度统计详情
export function getMonthOverWorkStaticsUpdate(id) {
  return request({
    url: '/attendance/attStatics/getMonthOverWorkStaticsUpdate/' + id,
    method: 'get'
  })
}
// 新增月度统计
export function addMonthOverWorkStaticsUpdate(data) {
  return request({
    url: '/attendance/attStatics/addMonthOverWorkStaticsUpdate',
    method: 'post',
    data: data
  })
}
// 查询每日考勤明细
export function getDayDetailStatics(query) {
  return request({
    url: '/attendance/attStatics/getDayDetailStatics',
    method: 'get',
    params: query
  })
}

// 查询外勤打卡明细
export function getOutSideCheckList(query) {
  return request({
    url: '/attendance/attStatics/getOutSideCheckList',
    method: 'get',
    params: query
  })
}

// 查询岗中打卡明细
export function getDayOndutyList(query) {
  return request({
    url: '/attendance/attStatics/getDayOndutyList',
    method: 'get',
    params: query
  })
}

export function getInWorkList(query) {
  return request({
    url: '/attendance/attStatics/getInWorkList',
    method: 'get',
    params: query
  })
}
