import request from '@/utils/request'

// 查询外出申请列表
export function listTAttOutsideApply(query) {
  return request({
    url: '/attendance/tAttOutsideApply/list',
    method: 'get',
    params: query
  })
}

// 查询外出申请详细
export function getTAttOutsideApply(id) {
  return request({
    url: '/attendance/tAttOutsideApply/' + id,
    method: 'get'
  })
}

// 新增外出申请
export function addTAttOutsideApply(data) {
  return request({
    url: '/attendance/tAttOutsideApply',
    method: 'post',
    data: data
  })
}

// 修改外出申请
export function updateTAttOutsideApply(data) {
  return request({
    url: '/attendance/tAttOutsideApply/edit',
    method: 'post',
    data: data
  })
}

// 删除外出申请
export function delTAttOutsideApply(id) {
  return request({
    url: '/attendance/tAttOutsideApply/delete',
    method: 'post',
    data: id
  })
}

// 更新实际外出时间
export function updateActualTime(data) {
  return request({
    url: '/attendance/tAttOutsideApply/updateActualTime',
    method: 'post',
    data: data
  })
}