import request from '@/utils/request'

// 查询出差申请列表
export function listTrip(query) {
  return request({
    url: '/attendance/trip/list',
    method: 'get',
    params: query
  })
}

// 查询出差申请详细
export function getTrip(id) {
  return request({
    url: '/attendance/trip/' + id,
    method: 'get'
  })
}

// 新增出差申请
export function addTrip(data) {
  return request({
    url: '/attendance/trip',
    method: 'post',
    data: data
  })
}

// 修改出差申请
export function updateTrip(data) {
  return request({
    url: '/attendance/trip/edit',
    method: 'post',
    data: data
  })
}

// 删除出差申请
export function delTrip(id) {
  return request({
    url: '/attendance/trip/delete/' + id,
    method: 'post'
  })
}


// 新增销假申请
export function addTripBack(data) {
  return request({
    url: '/attendance/tripBack',
    method: 'post',
    data: data
  })
}

// 查询销假申请详情
export function getInfoByTripId(id) {
  return request({
    url: '/attendance/tripBack/getInfoByTripId/' + id,
    method: 'get'
  })
}

// 修改销假申请
export function updateTripBack(data) {
  return request({
    url: '/attendance/tripBack/edit',
    method: 'post',
    data: data
  })
}
// 查询出差关闭申请详情
export function getTripBackId(id) {
  return request({
    url: '/attendance/tripBack/' + id,
    method: 'get'
  })
}
