import request from '@/utils/request'

// 查询考勤班次员工调整记录列表
export function listRecoud(query) {
  return request({
    url: '/attendance/record/list',
    method: 'get',
    params: query
  })
}

// 查询考勤班次员工调整记录详细
export function getRecoud(id) {
  return request({
    url: '/attendance/record/' + id,
    method: 'get'
  })
}

// 新增考勤班次员工调整记录
export function addRecoud(data) {
  return request({
    url: '/attendance/record',
    method: 'post',
    data: data
  })
}

// 修改考勤班次员工调整记录
export function updateRecoud(data) {
  return request({
    url: '/attendance/record',
    method: 'put',
    data: data
  })
}

// 删除考勤班次员工调整记录
export function delRecoud(id) {
  return request({
    url: '/attendance/record/' + id,
    method: 'delete'
  })
}


// 查询员工 考勤班次调整记录
export function getRecordList(query) {
  return request({
    url: '/attendance/record/getRecordList',
    method: 'get',
    params: query
  })
}
// 新增指定考勤班次员工调整记录
export function insertSpecialTAttShiftsUpRecord(data) {
  return request({
    url: '/attendance/record/insertSpecialTAttShiftsUpRecord',
    method: 'post',
    data: data
  })
}