import request from '@/utils/request'
/* BOSS页面接口 */

/**
 * 重点事务统计
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 * @param {string} query.taskStatus 任务状态 1待处理3超期未处理
 * @param {string} query.companyId 公司编码 10东莞公司 16昆山公司
 */
export function getTransactionStatics(query) {
  return request({
    url: '/business/bossController/getTransactionStatics',
    method: 'get',
    params: query
  })
}

/**
 * 重点事务列表
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 * @param {string} query.taskStatus 任务状态 1待处理3超期未处理
 * @param {string} query.companyId 公司编码 10东莞公司 16昆山公司
 * @param {string} query.themeName 主题
 * @param {number} query.pageNum 页码
 * @param {number} query.pageSize 数量
 */
export function getTransactionlist(query) {
  return request({
    url: '/business/bossController/getTransactionlist',
    method: 'get',
    params: query
  })
}

/**
 * 事务详情(暂时不用，复用原详情组件中的接口)
 * @param {string} id
 */
export function getTransactionInfo(id) {
  return request({
    url: '/business/bossController/getTransactionInfo/' + id,
    method: 'get'
  })
}