import request from '@/utils/request'
/* BOSS页面接口-ehs */

/**
 * EHS统计
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 */
export function getSecurityInspectStatics(query) {
  return request({
    url: '/business/bossController/getSecurityInspectStatics',
    method: 'get',
    params: query
  })
}

/**
 * 安全隐患列表
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 * @param {string} query.companyId 公司编码 10东莞公司 16昆山公司
 * @param {string} query.inspectType 检查类型
 * @param {string} query.reportType 报告分类
 * @param {number} query.pageNum 页码
 * @param {number} query.pageSize 数量
 */
export function getSecurityInspectDangerList(query) {
  return request({
    url: '/business/bossController/getSecurityInspectDangerList',
    method: 'get',
    params: query
  })
}

/**
 * 安全隐患列表
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 * @param {string} query.companyId 公司编码 10东莞公司 16昆山公司
 * @param {string} query.checkType 检查类型
 * @param {string} query.dangerType 隐患分类
 * @param {string} query.dangerStatus 隐患状态
 * @param {number} query.pageNum 页码
 * @param {number} query.pageSize 数量
 */
export function getSecurityInspectReportList(query) {
  return request({
    url: '/business/bossController/getSecurityInspectReportList',
    method: 'get',
    params: query
  })
}

/**
 * 安全检查详情
 * @param {string} id
 */
export function getSecurityInspectReportInfo(id) {
  return request({
    url: '/business/bossController/getSecurityInspectReportInfo/' + id,
    method: 'get'
  })
}

/**
 * 安全隐患详情
 * @param {string} id
 */
export function getSecurityInspectDangerInfo(id) {
  return request({
    url: '/business/bossController/getSecurityInspectDangerInfo/' + id,
    method: 'get'
  })
}