import request from '@/utils/request'
/* 问卷调查 */

/**
 * 问卷统计
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 */
export function getQuestionNaireStatucs(query) {
  return request({
    url: '/train/bossController/getQuestionNaireStatucs',
    method: 'get',
    params: query
  })
}

/**
 * 问卷列表查询
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 * @param {string} query.belongCompany 公司编码 10东莞公司 16昆山公司 18销售（从上一个接口中的belongCompany 获取）
 * @param {string} query.examinationType 问卷类型 （从上一个接口中的examinationType 获取）
 */
export function getQuestionNaireList(query) {
  return request({
    url: '/train/bossController/getQuestionNaireList',
    method: 'get',
    params: query
  })
}

/**
 * 培训详情
 * @param {string} id id
 */
export function statistics(id) {
  return request({
    url: '/train/bossController/statistics' + id,
    method: 'get'
  })
}