import request from '@/utils/request'
/* BOSS页面接口 */

/**
 * 培训列表查询
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 * @param {string} query.trainCompany 公司编码 10东莞公司 16昆山公司 18销售
 * @param {string} query.trainStatus 任务状态 1待处理3超期未处理
 * @param {string} query.trainType 一级分类
 * @param {string} query.trainSecondType 二级分类
 */
export function getTrainStatics(query) {
  return request({
    url: '/train/bossController/getTrainStatics',
    method: 'get',
    params: query
  })
}

/**
 * 培训列表查询
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 */
export function getTrainPlanList(query) {
  return request({
    url: '/train/bossController/getTrainPlanList',
    method: 'get',
    params: query
  })
}

/**
 * 培训详情(暂时不用，复用原详情组件中的接口)
 * @param {string} id
 */
export function getTrainPlanInfo(id) {
  return request({
    url: '/train/bossController/getTrainPlanInfo/' + id,
    method: 'get'
  })
}