import request from '@/utils/request'
/* BOSS页面接口 */

/**
 * 访客统计(新版列表)
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 * @param {string} query.visitorTheme 下拉，字典是visitor_theme这个
 */
export function getNewVisitorStatics(query) {
  return request({
    url: '/system/bossController/getNewVisitorStatics',
    method: 'get',
    params: query
  })
}

/**
 * 访客统计
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 */
export function getVisitorStatics(query) {
  return request({
    url: '/system/bossController/getVisitorStatics',
    method: 'get',
    params: query
  })
}

/**
 * 访客列表
 * @param {*} query
 * @param {string} query.searchBeginDate 查询开始日期
 * @param {string} query.searchEndDate 查询结束日期
 * @param {string} query.visitorType 访客类型 字典：visitor_type
 * @param {string} query.visitorTheme 访客主题 字典：visitor_theme
 * @param {number} query.pageNum 页码
 * @param {number} query.pageSize 数量
 */
export function getVisitorList(query) {
  return request({
    url: '/system/bossController/getVisitorList',
    method: 'get',
    params: query
  })
}

/**
 * 访客详情
 * @param {string} id
 */
export function getVisitorInfo(id) {
  return request({
    url: '/system/bossController/getVisitorInfo/' + id,
    method: 'get'
  })
}