import request from '@/utils/request'

// 查询门禁规则列表
export function listTAmAccessRules(query) {
  return request({
    url: '/business/TAmAccessRules/list',
    method: 'get',
    params: query
  })
}

// 查询门禁规则详细
export function getTAmAccessRules(id) {
  return request({
    url: '/business/TAmAccessRules/' + id,
    method: 'get'
  })
}

// 新增门禁规则
export function addTAmAccessRules(data) {
  return request({
    url: '/business/TAmAccessRules',
    method: 'post',
    data: data
  })
}

// 修改门禁规则
export function updateTAmAccessRules(data) {
  return request({
    url: '/business/TAmAccessRules/edit',
    method: 'post',
    data: data
  })
}

// 删除门禁规则
export function delTAmAccessRules(id) {
  return request({
    url: '/business/TAmAccessRules/delete/' + id,
    method: 'post'
  })
}
