import request from '@/utils/request'

// 查询用车申请列表
export function listTAmCarApply(query) {
  return request({
    url: '/business/TAmCarApply/list',
    method: 'get',
    params: query
  })
}

// 查询用车申请详细
export function getTAmCarApply(id) {
  return request({
    url: '/business/TAmCarApply/' + id,
    method: 'get'
  })
}

// 新增用车申请
export function addTAmCarApply(data) {
  return request({
    url: '/business/TAmCarApply',
    method: 'post',
    data: data
  })
}

// 修改用车申请
export function updateTAmCarApply(data) {
  return request({
    url: '/business/TAmCarApply/edit',
    method: 'post',
    data: data
  })
}

// 修改用车申请
export function updateCarTAmCarApply(data) {
  return request({
    url: '/business/TAmCarApply/carEdit',
    method: 'post',
    data: data
  })
}

// 删除用车申请
export function delTAmCarApply(id) {
  return request({
    url: '/business/TAmCarApply/delete/' + id,
    method: 'post'
  })
}


// 用车时间
export function selectTAmCarApplyTime(data) {
  return request({
    url: '/business/TAmCarApply/selectTAmCarApplyTime',
    method: 'post',
    data: data
  })
}