import request from '@/utils/request'

// 查询车辆保险列表
export function listTAmCarInsure(query) {
  return request({
    url: '/business/TAmCarInsure/list',
    method: 'get',
    params: query
  })
}

// 查询车辆保险详细
export function getTAmCarInsure(id) {
  return request({
    url: '/business/TAmCarInsure/' + id,
    method: 'get'
  })
}

// 新增车辆保险
export function addTAmCarInsure(data) {
  return request({
    url: '/business/TAmCarInsure',
    method: 'post',
    data: data
  })
}

// 修改车辆保险
export function updateTAmCarInsure(data) {
  return request({
    url: '/business/TAmCarInsure/edit',
    method: 'post',
    data: data
  })
}

// 删除车辆保险
export function delTAmCarInsure(id) {
  return request({
    url: '/business/TAmCarInsure/delete/' + id,
    method: 'post'
  })
}


// 新增车辆保险
export function insertTAmCarInsureAndFileList(data) {
  return request({
    url: '/business/TAmCarInsure/insertTAmCarInsureAndFileList',
    method: 'post',
    data: data
  })
}