import request from '@/utils/request'

// 查询车辆保养列表
export function listTAmCarMaintenance(query) {
  return request({
    url: '/business/TAmCarMaintenance/list',
    method: 'get',
    params: query
  })
}

// 查询车辆保养详细
export function getTAmCarMaintenance(id) {
  return request({
    url: '/business/TAmCarMaintenance/' + id,
    method: 'get'
  })
}

// 新增车辆保养
export function addTAmCarMaintenance(data) {
  return request({
    url: '/business/TAmCarMaintenance',
    method: 'post',
    data: data
  })
}

// 修改车辆保养
export function updateTAmCarMaintenance(data) {
  return request({
    url: '/business/TAmCarMaintenance/edit',
    method: 'post',
    data: data
  })
}

// 删除车辆保养
export function delTAmCarMaintenance(id) {
  return request({
    url: '/business/TAmCarMaintenance/delete/' + id,
    method: 'post'
  })
}


// 新增车辆保养
export function insertTAmCarMaintenanceAndList(data) {
  return request({
    url: '/business/TAmCarMaintenance/insertTAmCarMaintenanceAndList',
    method: 'post',
    data: data
  })
}