import request from '@/utils/request'

// 查询车辆管理 列表
export function listTAmCarManage(query) {
  return request({
    url: '/business/TAmCarManage/list',
    method: 'get',
    params: query
  })
}


// 查询车辆管理 列表
export function listTAmCarManageAll(query) {
  return request({
    url: '/business/TAmCarManage/listAll',
    method: 'get',
    params: query
  })
}

// 查询车辆管理 详细
export function getTAmCarManage(id) {
  return request({
    url: '/business/TAmCarManage/' + id,
    method: 'get'
  })
}

// 新增车辆管理
export function addTAmCarManage(data) {
  return request({
    url: '/business/TAmCarManage',
    method: 'post',
    data: data
  })
}

// 修改车辆管理
export function updateTAmCarManage(data) {
  return request({
    url: '/business/TAmCarManage/edit',
    method: 'post',
    data: data
  })
}

// 删除车辆管理
export function delTAmCarManage(id) {
  return request({
    url: '/business/TAmCarManage/delete/' + id,
    method: 'post'
  })
}

// 新增车辆管理
export function insertTAmCarManageAndFileList(data) {
  return request({
    url: '/business/TAmCarManage/insertTAmCarManageAndFileList',
    method: 'post',
    data: data
  })
}