import request from '@/utils/request'

// 查询车辆油耗列表
export function listTAmCarOil(query) {
  return request({
    url: '/business/TAmCarOil/list',
    method: 'get',
    params: query
  })
}

// 查询车辆油耗详细
export function getTAmCarOil(id) {
  return request({
    url: '/business/TAmCarOil/' + id,
    method: 'get'
  })
}

// 新增车辆油耗
export function addTAmCarOil(data) {
  return request({
    url: '/business/TAmCarOil',
    method: 'post',
    data: data
  })
}

// 修改车辆油耗
export function updateTAmCarOil(data) {
  return request({
    url: '/business/TAmCarOil/edit',
    method: 'post',
    data: data
  })
}

// 删除车辆油耗
export function delTAmCarOil(id) {
  return request({
    url: '/business/TAmCarOil/delete/' + id,
    method: 'post'
  })
}


// 新增车辆油耗
export function insertTAmCarOilFileList(data) {
  return request({
    url: '/business/TAmCarOil/insertTAmCarOilFileList',
    method: 'post',
    data: data
  })
}