import request from '@/utils/request'

// 查询车辆维修列表
export function listTAmCarUpkeep(query) {
  return request({
    url: '/business/TAmCarUpkeep/list',
    method: 'get',
    params: query
  })
}

// 查询车辆维修详细
export function getTAmCarUpkeep(id) {
  return request({
    url: '/business/TAmCarUpkeep/' + id,
    method: 'get'
  })
}

// 新增车辆维修
export function addTAmCarUpkeep(data) {
  return request({
    url: '/business/TAmCarUpkeep',
    method: 'post',
    data: data
  })
}

// 修改车辆维修
export function updateTAmCarUpkeep(data) {
  return request({
    url: '/business/TAmCarUpkeep/edit',
    method: 'post',
    data: data
  })
}

// 删除车辆维修
export function delTAmCarUpkeep(id) {
  return request({
    url: '/business/TAmCarUpkeep/delete/' + id,
    method: 'post'
  })
}

// 新增车辆维修
export function insertTAmCarUpkeepAndDetail(data) {
  return request({
    url: '/business/TAmCarUpkeep/insertTAmCarUpkeepAndDetail',
    method: 'post',
    data: data
  })
}
