import request from '@/utils/request'

// 查询车辆违章列表
export function listTAmCarViolation(query) {
  return request({
    url: '/business/TAmCarViolation/list',
    method: 'get',
    params: query
  })
}

// 查询车辆违章详细
export function getTAmCarViolation(id) {
  return request({
    url: '/business/TAmCarViolation/' + id,
    method: 'get'
  })
}

// 新增车辆违章
export function addTAmCarViolation(data) {
  return request({
    url: '/business/TAmCarViolation',
    method: 'post',
    data: data
  })
}

// 修改车辆违章
export function updateTAmCarViolation(data) {
  return request({
    url: '/business/TAmCarViolation/edit',
    method: 'post',
    data: data
  })
}

// 删除车辆违章
export function delTAmCarViolation(id) {
  return request({
    url: '/business/TAmCarViolation/delete/' + id,
    method: 'post'
  })
}


// 新增车辆违章
export function insertTAmCarViolationAndFileList(data) {
  return request({
    url: '/business/TAmCarViolation/insertTAmCarViolationAndFileList',
    method: 'post',
    data: data
  })
}
