import request from '@/utils/request'

// 查询客人报餐计划列表
export function listTAmGuestReportPlan(query) {
  return request({
    url: '/business/TAmGuestReportPlan/list',
    method: 'get',
    params: query
  })
}

// 查询客人报餐计划详细
export function getTAmGuestReportPlan(id) {
  return request({
    url: '/business/TAmGuestReportPlan/' + id,
    method: 'get'
  })
}

// 新增客人报餐计划
export function addTAmGuestReportPlan(data) {
  return request({
    url: '/business/TAmGuestReportPlan',
    method: 'post',
    data: data
  })
}

// 修改客人报餐计划
export function updateTAmGuestReportPlan(data) {
  return request({
    url: '/business/TAmGuestReportPlan/edit',
    method: 'post',
    data: data
  })
}

// 删除客人报餐计划
export function delTAmGuestReportPlan(id) {
  return request({
    url: '/business/TAmGuestReportPlan/delete/' + id,
    method: 'post'
  })
}


// 新增客人报餐计划
export function insertTAmGuestReportPlanInfo(data) {
  return request({
    url: '/business/TAmGuestReportPlan/insertTAmGuestReportPlanInfo',
    method: 'post',
    data: data
  })
}