import request from '@/utils/request'

// 查询监控设备检查记录列表
export function listTAmInspectionRecords(query) {
  return request({
    url: '/business/TAmInspectionRecords/list',
    method: 'get',
    params: query
  })
}

// 查询监控设备检查记录详细
export function getTAmInspectionRecords(id) {
  return request({
    url: '/business/TAmInspectionRecords/' + id,
    method: 'get'
  })
}

// 新增监控设备检查记录
export function addTAmInspectionRecords(data) {
  return request({
    url: '/business/TAmInspectionRecords',
    method: 'post',
    data: data
  })
}

// 修改监控设备检查记录
export function updateTAmInspectionRecords(data) {
  return request({
    url: '/business/TAmInspectionRecords/edit',
    method: 'post',
    data: data
  })
}

// 删除监控设备检查记录
export function delTAmInspectionRecords(id) {
  return request({
    url: '/business/TAmInspectionRecords/delete',
    method: 'post',
    data: id
  })
}
