import request from '@/utils/request'

// 查询 厂区报修列表
export function listTAmRepairFactory(query) {
  return request({
    url: '/business/TAmRepairFactory/list',
    method: 'get',
    params: query
  })
}

// 查询 厂区报修详细
export function getTAmRepairFactory(id) {
  return request({
    url: '/business/TAmRepairFactory/' + id,
    method: 'get'
  })
}

// 新增 厂区报修
export function addTAmRepairFactory(data) {
  return request({
    url: '/business/TAmRepairFactory',
    method: 'post',
    data: data
  })
}

// 修改 厂区报修
export function updateTAmRepairFactory(data) {
  return request({
    url: '/business/TAmRepairFactory/edit',
    method: 'post',
    data: data
  })
}

// 删除 厂区报修
export function delTAmRepairFactory(id) {
  return request({
    url: '/business/TAmRepairFactory/delete/' + id,
    method: 'post'
  })
}


// 新增宿舍报修管理
export function insertTAmRepairFactoryAndResult(data) {
  return request({
    url: '/business/TAmRepairFactory/insertTAmRepairFactoryAndResult',
    method: 'post',
    data: data
  })
}