import request from '@/utils/request'

// 查询宿舍报修管理列表
export function listTAmRepairReport(query) {
  return request({
    url: '/business/TAmRepairReport/list',
    method: 'get',
    params: query
  })
}

// 查询宿舍报修管理列表
export function listAllRoomNum(query) {
  return request({
    url: '/business/tAmRoomManage/listAll',
    method: 'get',
    params: query
  })
}

// 查询宿舍报修管理详细
export function getTAmRepairReport(id) {
  return request({
    url: '/business/TAmRepairReport/' + id,
    method: 'get'
  })
}

// 新增宿舍报修管理
export function addTAmRepairReport(data) {
  return request({
    url: '/business/TAmRepairReport',
    method: 'post',
    data: data
  })
}

// 修改宿舍报修管理
export function updateTAmRepairReport(data) {
  return request({
    url: '/business/TAmRepairReport/edit',
    method: 'post',
    data: data
  })
}

// 删除宿舍报修管理
export function delTAmRepairReport(id) {
  return request({
    url: '/business/TAmRepairReport/delete/' + id,
    method: 'post'
  })
}


// 新增宿舍报修管理
export function insertTAmRepairReportAndResult(data) {
  return request({
    url: '/business/TAmRepairReport/insertTAmRepairReportAndResult',
    method: 'post',
    data: data
  })
}