import request from '@/utils/request'

// 查询保安巡逻记录列表
export function listTAmSecurityRecords(query) {
  return request({
    url: '/business/TAmSecurityRecords/list',
    method: 'get',
    params: query
  })
}

// 查询保安巡逻记录详细
export function getTAmSecurityRecords(id) {
  return request({
    url: '/business/TAmSecurityRecords/' + id,
    method: 'get'
  })
}

// 新增保安巡逻记录
export function addTAmSecurityRecords(data) {
  return request({
    url: '/business/TAmSecurityRecords',
    method: 'post',
    data: data
  })
}

// 修改保安巡逻记录
export function updateTAmSecurityRecords(data) {
  return request({
    url: '/business/TAmSecurityRecords/edit',
    method: 'post',
    data: data
  })
}

// 删除保安巡逻记录
export function delTAmSecurityRecords(id) {
  return request({
    url: '/business/TAmSecurityRecords/delete',
    method: 'post',
    data: id
  })
}
