import request from '@/utils/request'

// 查询食堂证照列表
export function listCERTIFICATE(query) {
  return request({
    url: '/business/canteenCertificate/getList',
    method: 'get',
    params: query
  })
}

// 查询食堂证照详细
export function getCERTIFICATE(id) {
  return request({
    url: '/business/canteenCertificate/' + id,
    method: 'get'
  })
}

// 新增食堂证照
export function addCERTIFICATE(data) {
  return request({
    url: '/business/canteenCertificate',
    method: 'post',
    data: data
  })
}

// 修改食堂证照
export function updateCERTIFICATE(data) {
  return request({
    url: '/business/canteenCertificate/edit',
    method: 'post',
    data: data
  })
}

// 删除食堂证照
export function delCERTIFICATE(id) {
  return request({
    url: '/business/canteenCertificate/delete/' + id,
    method: 'post'
  })
}
