import request from '@/utils/request'

// 查询检查配置头列表
export function listCheckTabelManageTitle(query) {
  return request({
    url: '/business/checkTabelManageTitle/list',
    method: 'get',
    params: query
  })
}

// 查询检查配置头详细
export function getCheckTabelManageTitle(id) {
  return request({
    url: '/business/checkTabelManageTitle/' + id,
    method: 'get'
  })
}

// 新增检查配置头
export function addCheckTabelManageTitle(data) {
  return request({
    url: '/business/checkTabelManageTitle',
    method: 'post',
    data: data
  })
}

// 修改检查配置头
export function updateCheckTabelManageTitle(data) {
  return request({
    url: '/business/checkTabelManageTitle/edit',
    method: 'post',
    data: data
  })
}

// 删除检查配置头
export function delCheckTabelManageTitle(id) {
  return request({
    url: '/business/checkTabelManageTitle/delete/' + id,
    method: 'post'
  })
}
