import request from '@/utils/request'

// 查询检查管理列表
export function listINFO(query) {
  return request({
    url: '/business/tchecktableinfo/list',
    method: 'get',
    params: query
  })
}
// 查询检查管理表头不分页
export function getAllHead(query) {
  return request({
    url: '/business/INFO/getAllHead',
    method: 'get',
    params: query
  })
}


// 查询检查管理详细
export function getINFO(id) {
  return request({
    url: '/business/tchecktableinfo/' + id,
    method: 'get'
  })
}

// 查询检查管理详细
export function getInfoById(id) {
  return request({
    url: '/business/tchecktableinfo/getInfoById/' + id,
    method: 'get'
  })
}
// 新增检查管理
export function addINFO(data) {
  return request({
    url: '/business/tchecktableinfo',
    method: 'post',
    data: data
  })
}

// 修改检查管理
export function updateINFO(data) {
  return request({
    url: '/business/tchecktableinfo/edit',
    method: 'post',
    data: data
  })
}

// 删除检查管理
export function delINFO(id) {
  return request({
    url: '/business/tchecktableinfo/delete/' + id,
    method: 'post'
  })
}

// 制表检查管理
export function insertTabulation(data) {
  return request({
    url: '/business/tchecktableinfo/insertTabulation',
    method: 'post',
    data: data
  })
}
