import request from '@/utils/request'

// 查询检查管理列表
export function listCheckTableManage(query) {
  return request({
    url: '/business/checkTableManage/list',
    method: 'get',
    params: query
  })
}

// 查询检查管理详细
export function getCheckTableManage(id) {
  return request({
    url: '/business/checkTableManage/' + id,
    method: 'get'
  })
}

// 新增检查管理
export function addCheckTableManage(data) {
  return request({
    url: '/business/checkTableManage',
    method: 'post',
    data: data
  })
}

// 修改检查管理
export function updateCheckTableManage(data) {
  return request({
    url: '/business/checkTableManage/edit',
    method: 'post',
    data: data
  })
}

// 删除检查管理
export function delCheckTableManage(id) {
  return request({
    url: '/business/checkTableManage/delete/' + id,
    method: 'post'
  })
}

// 制表
export function tableManageCreateTable(data) {
  return request({
    url: '/business/checkTableManage/createTable',
    method: 'post',
    data: data
  })
}

// 查询检查记录详细
export function getRecordInfo(query) {
  return request({
    url: '/business/checkTableManage/recordInfo',
    method: 'get',
    params: query
  })
}