import request from '@/utils/request'

// 查询安全证书检测列表
export function listDETECTION(query) {
  return request({
    url: '/business/securityCertificate/list',
    method: 'get',
    params: query
  })
}

// 查询安全证书检测详细
export function getDETECTION(id) {
  return request({
    url: '/business/securityCertificate/' + id,
    method: 'get'
  })
}

// 新增安全证书检测
export function addDETECTION(data) {
  return request({
    url: '/business/securityCertificate',
    method: 'post',
    data: data
  })
}

// 修改安全证书检测
export function updateDETECTION(data) {
  return request({
    url: '/business/securityCertificate/edit',
    method: 'post',
    data: data
  })
}

// 删除安全证书检测
export function delDETECTION(id) {
  return request({
    url: '/business/securityCertificate/delete/' + id,
    method: 'post'
  })
}
