import request from '@/utils/request'

// 查询药品列表
export function listDRUG(query) {
  return request({
    url: '/business/drug/list',
    method: 'get',
    params: query
  })
}

// 查询药品详细
export function getDRUG(id) {
  return request({
    url: '/business/drug/' + id,
    method: 'get'
  })
}

// 新增药品
export function addDRUG(data) {
  return request({
    url: '/business/drug',
    method: 'post',
    data: data
  })
}

// 修改药品
export function updateDRUG(data) {
  return request({
    url: '/business/drug/edit',
    method: 'post',
    data: data
  })
}

// 删除药品
export function delDRUG(id) {
  return request({
    url: '/business/drug/delete/' + id,
    method: 'post'
  })
}
