import request from '@/utils/request'

// 查询药品补充计划列表
export function listDrugSupplementPlan(query) {
  return request({
    url: '/business/drugSupplementPlan/list',
    method: 'get',
    params: query
  })
}

// 查询药品补充计划详细
export function getDrugSupplementPlan(id) {
  return request({
    url: '/business/drugSupplementPlan/' + id,
    method: 'get'
  })
}

// 新增药品补充计划
export function addDrugSupplementPlan(data) {
  return request({
    url: '/business/drugSupplementPlan',
    method: 'post',
    data: data
  })
}

// 修改药品补充计划
export function updateDrugSupplementPlan(data) {
  return request({
    url: '/business/drugSupplementPlan/edit',
    method: 'post',
    data: data
  })
}

// 删除药品补充计划
export function delDrugSupplementPlan(id) {
  return request({
    url: '/business/drugSupplementPlan/delete/' + id,
    method: 'post'
  })
}
