import request from '@/utils/request'

// 查询药品领用列表
export function listUSE(query) {
  return request({
    url: '/business/drugUse/list',
    method: 'get',
    params: query
  })
}

// 查询药品领用详细
export function getUSE(id) {
  return request({
    url: '/business/drugUse/' + id,
    method: 'get'
  })
}

// 新增药品领用
export function addUSE(data) {
  return request({
    url: '/business/drugUse',
    method: 'post',
    data: data
  })
}

// 修改药品领用
export function updateUSE(data) {
  return request({
    url: '/business/drugUse/edit',
    method: 'post',
    data: data
  })
}

// 删除药品领用
export function delUSE(id) {
  return request({
    url: '/business/drugUse/delete' + id,
    method: 'post'
  })
}
